<!DOCTYPE html>
<!--
Copyright (c) 2003-2019, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
-->
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />
    <link type="text/css" href="sample/css/sample.css" rel="stylesheet" media="screen" />
    <title>CKEditor 5 – classic editor build sample</title>
</head>

<body>



    <main>

        <div class="centered">
            <div id="editor">
                <h2>The three greatest things you learn from traveling</h2>

                <p>Like all the great things on earth traveling teaches us by example. Here are some of the most precious lessons I’ve learned over the years of traveling.</p>

                <h3>Appreciation of diversity</h3>

                <p>Getting used to an entirely different culture can be challenging. While it’s also nice to learn about cultures online or from books, nothing comes close to experiencing <a href="https://en.wikipedia.org/wiki/Cultural_diversity">cultural diversity</a>                    in person. You learn to appreciate each and every single one of the differences while you become more culturally fluid.</p>



                <h3>Confidence</h3>

                <p>Going to a new place can be quite terrifying. While change and uncertainty makes us scared, traveling teaches us how ridiculous it is to be afraid of something before it happens. The moment you face your fear and see there was nothing
                    to be afraid of, is the moment you discover bliss.</p>
            </div>


        </div>
    </main>



    <script src="/cd/ckeditor5/ckeditor.js"></script>

    <script>
        ClassicEditor
            .create(document.querySelector('#editor'), {
                
                ckfinder: {
                    uploadUrl: 'http://demo.childsafe.or.th/pages/upload'
                }
                // toolbar: [ 'heading', '|', 'bold', 'italic', 'link' ]
            })
            .then(editor => {
                window.editor = editor;
            })
            .catch(err => {
                console.error(err.stack);
            });
    </script>

</body>

</html>