<?php

class Admin extends CI_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        $this->SetModel->admin_header();
        $this->SetModel->admin_footer();
    }

    function pages($pages = 'test', $status = NULL) {
        $data['status'] = $status;
        $pa = $this->db->where("cat_pagename", $pages)->get("cat")->first_row("array");
        if (count($pa) > 0) {
            $data['pages'] = $pa;
            if ($status == NULL) {
                $data['data'] = $this->db->where("cat_id", $pa['cat_id'])
                                ->order_by("blog_date", "DESC")
                                ->get("blog")->result_array();
            } else {
                $data['data'] = $this->db->where("cat_id", $pa['cat_id'])
                                ->order_by("blog_date", "DESC")
                                ->where("blog_status", $status)->get("blog")->result_array();
            }

            $this->SetModel->admin_header();
            $this->load->view("admin/homeadmin", $data);
            $this->SetModel->admin_footer();
        } else {
            redirect("admin");
        }
    }

    function gallery($page_id) {
        $data['img'] = $this->db->where("page_id", $page_id)->get("gallery")->result_array();
        $data['id'] = $page_id;
        $this->SetModel->admin_header();
        $this->load->view("admin/gallery", $data);
        $this->SetModel->admin_footer();
    }

    function uploadimg($id) {
        $data['page_id'] = $id;
        $config['upload_path'] = './upload/';
        $config['allowed_types'] = '*';
        $config['file_name'] = date("Ymdhis") . str_replace(" ", "%", $_FILES['file']['name']);
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload("file")) {
            $data['img'] = $config['file_name'];
        } else {
            $error = array('error' => $this->upload->display_errors());
//            print_r($error);
        }
        $this->db->insert("gallery", $data);
        redirect("admin/gallery/" . $id);
    }

    function removeimg($id, $img) {
        $this->db->where("img_id", $img)->delete("gallery");
        redirect("admin/gallery/" . $id);
    }

    function vdo() {
        
    }

    function contact() {
        $data['contact'] = $this->db->get("contact")->first_row("array");
        $this->SetModel->admin_header();
        $this->load->view("admin/contact", $data);
        $this->load->view("admin/ckscript");
        $this->SetModel->admin_footer();
    }

    function update_contact() {
        print_r($_POST);
        $this->db->where("contact_id", 1)->update("contact", $_POST);
        redirect("admin/contact");
    }

    function add($pages = '') {
        $pa = $this->db->where("cat_id", $pages)->get("cat")->first_row("array");

        if (count($pa) > 0) {
            $data['pages'] = $pa;
            $this->SetModel->admin_header();
            $this->load->view("admin/add", $data);
            $this->load->view("admin/ckscript");
            $this->SetModel->admin_footer();
        } else {
            redirect("admin");
        }
    }

    function insert($id) {
        echo "<pre>";
        print_r($_POST);
        $uid = md5(date("Ymdhis"));
        $data = array(
            "blog_id" => $uid,
            "blog_title_th" => $_POST['blog_title_th'],
            "blog_title_en" => $_POST['blog_title_en'],
            "blog_detail_th" => $_POST['blog_detail_th'],
            "blog_detail_en" => $_POST['blog_detail_en'],
            "cat_id" => $id,
            "blog_date" => date("Y-m-d H:i:s"),
            "blog_sub_detail_th" => $_POST['blog_sub_detail_th'],
            "blog_sub_detail_en" => $_POST['blog_sub_detail_en'],
        );
        $config['upload_path'] = './upload/';
        $config['allowed_types'] = '*';
        $config['file_name'] = date("Ymdhis") . str_replace(" ", "%", $_FILES['file']['name']);
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload("file")) {
            $data['blog_img'] = $config['file_name'];
        } else {
            $error = array('error' => $this->upload->display_errors());
//            print_r($error);
        }
        $this->db->insert("blog", $data);
        redirect("admin/opblog/" . $uid);
    }

    function opblog($id) {
        $this->load->model("blog_model");
        $pa = $this->blog_model->getblog($id);
        if (count($pa) > 0) {
            $data['blog'] = $pa;
            $this->SetModel->admin_header();
            $this->load->view("admin/blog", $data);
            $this->load->view("admin/ckscript");
            $this->SetModel->admin_footer();
        } else {
            redirect("admin");
        }
    }

    function updateblog($id) {
        $data = array(
            "blog_title_th" => $_POST['blog_title_th'],
            "blog_title_en" => $_POST['blog_title_en'],
            "blog_detail_th" => $_POST['blog_detail_th'],
            "blog_detail_en" => $_POST['blog_detail_en'],
            "blog_sub_detail_th" => $_POST['blog_sub_detail_th'],
            "blog_sub_detail_en" => $_POST['blog_sub_detail_en'],
        );
        $config['upload_path'] = './upload/';
        $config['allowed_types'] = '*';
        $config['file_name'] = date("Ymdhis") . str_replace(" ", "%", $_FILES['file']['name']);
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload("file")) {
            $data['blog_img'] = $config['file_name'];
        } else {
            $error = array('error' => $this->upload->display_errors());
//            print_r($error);
        }
        $this->db->where("blog_id", $id);
        $this->db->update("blog", $data);
        redirect("admin/opblog/" . $id);
    }

    function status($status, $id) {
        $data['blog_status'] = $status;
        $this->db->where("blog_id", $id);
        $this->db->update("blog", $data);
        redirect("admin/opblog/" . $id);
    }

    function singlepage() {

        $data['page'] = $this->db->select("page_id,page_title_th,page_title_en,lastUpdate")
                        ->get("page")->result_array();
//        print_r($data);

        $this->SetModel->admin_header();
        $this->load->view("admin/page", $data);
        $this->SetModel->admin_footer();
    }

    function pageedit($id) {

        $data['page'] = $this->db->where("page_id", $id)
                        ->get("page")->first_row("array");
        $this->SetModel->admin_header();
        $this->load->view("admin/pageedit", $data);
        $this->load->view("admin/ckscript");
        $this->SetModel->admin_footer();
    }

    function pageupdate($id) {
        $data = array(
            "page_title_th" => $_POST['page_title_th'],
            "page_title_en" => $_POST['page_title_en'],
            "page_detail_th" => $_POST['page_detail_th'],
            "page_detail_en" => $_POST['page_detail_en']
        );

        $config['upload_path'] = './upload/';
        $config['allowed_types'] = '*';
        $config['file_name'] = date("Ymdhis") . str_replace(" ", "%", $_FILES['home_bg']['name']);
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload("file")) {
            $data['cover'] = $config['file_name'];
        } else {
            $error = array('error' => $this->upload->display_errors());
//            print_r($error);
        }

        $this->db->where("page_id", $id)->update("page", $data);

        redirect("admin/pageedit/" . $id);
    }

    function homepage() {

        $data['homepage'] = $this->db->get("homepage")->result_array();
        $this->SetModel->admin_header();
        $this->load->view("admin/homepage", $data);
        $this->SetModel->admin_footer();
    }

    function homepage_edit($id) {
        $data['homepage'] = $this->db->where("home_id", $id)
                        ->get("homepage")->first_row("array");
        $this->SetModel->admin_header();
        $this->load->view("admin/homepage_edit", $data);
        $this->load->view("admin/ckscript");
        $this->SetModel->admin_footer();
    }

    function updatehome($id) {
        print_r($_FILES);
        $data = array(
            "home_name_th" => $_POST['home_name_th'],
            "home_name_en" => $_POST['home_name_en'],
            "home_detail_th" => $_POST['home_detail_th'],
            "home_detail_en" => $_POST['home_detail_en'],
            "home_cover_align" => $_POST['home_cover_align'],
        );
        $config['upload_path'] = './upload/';
        $config['allowed_types'] = '*';
        $config['file_name'] = date("Ymdhis") . str_replace(" ", "%", $_FILES['home_bg']['name']);
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload("home_bg")) {
            $data['home_bg'] = $config['file_name'];
        } else {
            $error = array('error' => $this->upload->display_errors());
//            print_r($error);
        }

        $config['upload_path'] = './upload/';
        $config['allowed_types'] = '*';
        $config['file_name'] = date("Ymdhis") . str_replace(" ", "%", $_FILES['home_cover']['name']);
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload("home_cover")) {
            $data['home_cover'] = $config['file_name'];
        } else {
            $error = array('error' => $this->upload->display_errors());
//            print_r($error);
        }

        $this->db->where("home_id", $id)->update("homepage", $data);
        redirect("admin/homepage");
    }

    function message() {

        $data['list'] = $this->db->get("message")->result_array();
        $this->SetModel->admin_header();
        $this->load->view("admin/message", $data);
        $this->SetModel->admin_footer();
    }

    function messageopen($id) {
        $data['list'] = $this->db->where("message_id", $id)->get("message")->first_row("array");
        $this->db->where("message_id", $id)->update("message", array("read" => 1));
        $this->SetModel->admin_header();
        $this->load->view("admin/messageopen", $data);
        $this->SetModel->admin_footer();
    }

    function pay() {

        $data['list'] = $this->db->get("pay")->result_array();
        $this->SetModel->admin_header();
        $this->load->view("admin/pay", $data);
        $this->SetModel->admin_footer();
    }

    function payopen($id) {
        $data['for'][0]= "อื่นๆ";
        $data['for'][1]= "ของขวัญ";
        $data['for'][2]= "ทุนการศึกษา ครั้งเดียว";
        $data['for'][3]= "ทุนการศึกษา รายเดือน";
        $data['for'][4]= "พันธกิจ";
        $data['list'] = $this->db->where("pay_id", $id)->get("pay")->first_row("array");
        $this->db->where("pay_id", $id)->update("pay", array("pay_read" => 1));
        $this->SetModel->admin_header();
        $this->load->view("admin/payopen", $data);
        $this->SetModel->admin_footer();
    }

}
